#Ethernet Battleship
#Written by Marc Howard - Spring 2012

import numpy as np
import Tkinter as tk
import socket
from PIL import Image, ImageTk
import PIL.ImageOps

display32 = np.zeros((15,12,4), int)
display16 = np.zeros((30,16,4), int)
playerScore = 0
opponentScore = 0 
turn = 1
cursorX = 0
cursorY = 0
displaySetting = 0 #0 = player ships big, opponent ships small;  1 = opponent ships big, player ships small
exitGame = 0  #0 = keep going, 1 = exit game
exitPlayer = 1 #0 = Keep same player, 1 = New player
exitRound = 0  #0 = keep going, 1 = exit round
playerName = "Your Name"
opponentName = "Their Name"
sockSend = socket.socket( socket.AF_INET, # Internet
                      socket.SOCK_DGRAM ) # UDP

sockReceive = socket.socket( socket.AF_INET, # Internet
					      socket.SOCK_DGRAM ) # UDP
					
root = tk.Tk()
canvas = tk.Canvas(root, width = 640, height = 480)
canvas.pack()
tkimages = []
tiles32 = []
tiles16 = []
inputKey = ""
patrolboatleft = 2
submarineleft = 3
destroyerleft = 3
battleshipleft = 4
carrierleft = 5


def main():
	global exitPlayer
	global exitGame
	
	root.bind_all('<Key>', key)
	print( "I have bound keys")
	initializeNetworking("192.168.1.1", "192.168.1.2", 5005)
	print("I have initialized networking")

	
	sendPacket("Test")
	#receivePacket()
	#receivePacket()
	
	initializeDisplayData()
	print("I have imported data")
	while exitGame == 0:
		print("I have determined that the game is not over")
		if exitPlayer == 1:
			print("I am setting up a game for new players")
			setupGame()
		print "I am going to play a new round now"
		playGame()
		print "I am going to check if the player wants to play again"
		checkPlayAgain()
	print "I am going to quit the game now"
	quitGame()
	
	return

#Setup a game
def setupGame():
	global playerName, exitGame, exitRound, tkimages
	tkimages = []
	print "I am initializing the display now"
	initializeDisplay()
	exitGame = 0
	exitRound = 0
	playerName = getPlayerName()
	return

#Play a game.  Initialize the round, then play a round.
def playGame():
	global exitPlayer
	global exitRound
	global turn
	
	initializeRound() #This sets up the ships and waits until both players are ready

	while exitRound == 0:
		#Play the game.  exitRound should be set to 1 if a player wins, 2 if a player quits the game using the quit condition (implement), 3 if the game goes out of sync. or 4 if another error occurs
		if turn == 0: #If players turn, enact that.
			playerTurn()
			turn = 1; #Set turn to opponent.
		elif turn == 1: #If opponent turn, enact that.
			opponentTurn()
			turn = 0 #Set turn to player.
		else: #Error condition.  Should never occur.
			exitRound = 4
		if playerScore >= 17 or opponentScore >= 17:
			exitRound = 1
	#End of game loop
			
	#If game ended in victory
	if exitRound == 1: 
		if playerScore == 17: #Player win condition.  Enact player victory.
			playerVictory() 
		elif opponentScore == 17: #Opponent win condition.  Enact opponent victory.
			opponentVictory()
	
	#If player chose to exit game.
	elif exitRound == 2: 
		print("Player quit game.  Goodbye!")
		sendPacket("Player Quit")
		
	#If game falls out of sync.
	elif exitRound == 3:
		print("Game out of sync.  Game ending.  Sorry!")
		sendPacket("Out of Sync Quit")
	
	#If other error condition occurs
	else:
		print ("Game error.  Game ending.  Sorry!")	
		sendPacket("Game Error Quit")
	return
	
#Exit the game, closing the socket and game window
def quitGame():
	sockSend.close()
	sockReceive.close()
	#Close game window.
	return
	
#Set up the basic screen display, with a blank ocean and player name for both screens.
def initializeDisplay():
	#Display the 32 side
	#Display border on the 32 side
	for c in range (0,5):
		changeTile32(0,c,8,0,0,0)
	for r in range (0,15):
		changeTile32(r,0,8,0,0,0)
	for c in range (0,12):
		changeTile32(14,c,8,0,0,0)
		
	#Display the Battleship Title on the 32 side
	for i in range (0,7):
		changeTile32(0,5+i,109+i,0,0,0)
		
	#Display the battleship title on the 16 side
	for c in range (0,3):
		changeTile16(0,0 + (2*c),112 + (4*c),0,0,0)
		changeTile16(1,0 + (2*c),114 + (4*c),0,0,0)
		changeTile16(0,1 + (2*c),113 + (4*c),0,0,0)
		changeTile16(1,1 + (2*c),115 + (4*c),0,0,0)
		
	for c in range (3,8):
		changeTile16(0,0 + (2*c),8,0,0,0)
		changeTile16(1,0 + (2*c),10,0,0,0)
		changeTile16(0,1 + (2*c),9,0,0,0)
		changeTile16(1,1 + (2*c),11,0,0,0)
		
	#Display the blank text squares on the 32 side
	for r in range (1,3):
		for c in range (1,12):
			changeTile32(r,c,11,0,0,0)
	changeTile32(3,1,11,0,0,0)
	
	#Display the numbers along the top of the battle screen on the 32 side
	for c in range (0,10):
		changeTile32(3,2+c,65+c,0,0,0)
		
	#Display the letters along the side of the battle screen on the 32 side
	for r in range (0,10):
		changeTile32(4+r,1,12+r,0,0,0)
		
	#Display the ocean on the 32 side
	for r in range (0,10):
		for c in range (0,10):
			changeTile32(r+4,c+2,5,0,0,0)
	
	#Display the 16 side
	#Display the border on the 16 side.  Fill the entire side with border.  This will be overwritten as necessary.
	for r in range (1,15):
		for c in range (0,8):
			changeTile16(r*2+0,0 + (2*c),8,0,0,0)
			changeTile16(r*2+1,0 + (2*c),10,0,0,0)
			changeTile16(r*2+0,1 + (2*c),9,0,0,0)
			changeTile16(r*2+1,1 + (2*c),11,0,0,0)
	
	#Display the blank text squares on the 16 side
	for r in range (0,2):
		for c in range (0,11):
			changeTile16(r+3, c+2,14,0,0,0)
			changeTile16(r+19, c+2,14,0,0,0)
			changeTile16(r+22, c+2,14,0,0,0)
			changeTile16(r+25, c+2,14,0,0,0)
	changeTile16(6, 2,14,0,0,0)
	
	#Display the numbers along the top of the battle screen on the 16 side
	for c in range (0,10):
		changeTile16(6,3+c,68+c,0,0,0)
		
	#Display the letters along the side of the battle screen on the 16 side
	for r in range (0,10):
		changeTile16(7+r,2,15+r,0,0,0)
		
	#Display the ocean on the 16 side
	for r in range (0,10):
		for c in range (0,10):
			changeTile16(r+7,c+3,5,0,0,0)

	return

#Sets the value of that square on the screen to the data provided	
def changeTile32(row, col, tileNumber, rotate, flip, invert):
	display32[row,col,0] = tileNumber
	display32[row,col,1] = rotate
	display32[row,col,2] = flip
	display32[row,col,3] = invert
	if row > 14 or col > 11 or row < 0 or col < 0:
		print "Invalid row and column:"
		print row
		print col
		return
	if tileNumber > 117 or tileNumber < 0:
		print "Invalid Tile Number:"
		print tileNumber
	image = tiles32[tileNumber]
	if rotate and flip:
		image = image.rotate(270)
	elif flip:
		image = image.rotate(180)
	elif rotate:
		image = image.rotate(90)
	if invert:
		image = PIL.ImageOps.invert(image)
	tkimage = ImageTk.PhotoImage(image)
	tkimages.append(tkimage)
	item = canvas.create_image(col*32, row*32, image = tkimage, anchor = 'nw')
	root.update()
	return
	
#Sets the value of that square on the screen to the data provided		
def changeTile16(row, col, tileNumber, rotate, flip, invert):
	display16[row,col,0] = tileNumber
	display16[row,col,1] = rotate
	display16[row,col,2] = flip
	display16[row,col,3] = invert
	if row > 29 or col > 15 or row < 0 or col < 0:
		print "Invalid row and column:"
		print row
		print col
		return
	if tileNumber > 125 or tileNumber < 0:
		print "Invalid Tile Number:"
		print tileNumber
	image = tiles16[tileNumber]
	if rotate and flip:
		image = image.rotate(270)
	elif flip:
		image = image.rotate(180)
	elif rotate:
		image = image.rotate(90)
	if invert:
		image = PIL.ImageOps.invert(image)
	tkimage = ImageTk.PhotoImage(image)
	tkimages.append(tkimage)
	item = canvas.create_image(12*32 + col*16, row*16, image = tkimage, anchor = 'nw')
	root.update()
	return	
	
#Invert a square on the 32 side
def invert32(row, col):
	if display32[row, col, 3] == 0:
		display32[row, col, 3] = 1
	elif display32[row, col, 3] == 1:
		display32[row, col, 3] = 0
	changeTile32(row, col, display32[row,col,0], display32[row,col,1], display32[row,col,2], display32[row,col,3])	
	return
	
	
#Invert a square on the 16 side		
def invert16(row, col):
	if display16[row, col, 3] == 0:
		display16[row, col, 3] = 1
	elif display16[row, col, 3] == 1:
		display16[row, col, 3] = 0
	changeTile16(row, col, display16[row,col,0], display16[row,col,1], display16[row,col,2], display16[row,col,3])	
	return	

	
#Display a string on the 32 side
def displayString32(string, row, col):
	l = len(string)
	for i in range (0, l):
		displayChar32(string[i], row, col + i)
	return
	
#Display a string on the 16 side
def displayString16(string, row, col):
	l = len(string)
	for i in range (0, l):
		displayChar16(string[i], row, col + i)
	return
	
# Setup the Network interface
def initializeNetworking(IP_ADDRESS_OTHER, IP_ADDRESS_SELF, PORT):
	sockSend.connect((IP_ADDRESS_OTHER, PORT))
	sockReceive.bind((IP_ADDRESS_SELF, PORT))
	return

#Send a packet with a string message.
def sendPacket(message):
	sockSend.send(message)
	return	

#Receive a packet with a string message
def receivePacket():
	data, addr = sockReceive.recvfrom( 1024 ) # buffer size is 1024 bytes
	print "received message:", data
	return data
	
#Check if the player wants to play again.
def checkPlayAgain():
	global exitPlayer, cursorX, cursorY
	displayString32("Play Again?", 1, 1)
	displayString32("    Y N    ", 2, 1)
	cursorX = 5
	cursorY = 2
	invert32(cursorY, cursorX)
	exitPlayer = -1
	while  exitPlayer == -1:
		input = getInput() 
		if input == "Left" and cursorX == 7:
			invert32(cursorY, cursorX)
			cursorX = 5
			invert32(cursorY, cursorX)
		elif input == "Right" and cursorX == 5:
			invert32(cursorY, cursorX)
			cursorX = 7
			invert32(cursorY, cursorX)
	 	elif input == "Return":
			invert32(cursorY, cursorX)
			if cursorX == 5:
				exitPlayer = 0
			else:
				exitPlayer = 1
	return

#Display a character at a coordinate on the 32 side	
def displayChar32(string, row, col):
	char = ""
	if string == "A":
		char = string
		changeTile32(row, col, 12, 0, 0, 0)
	elif string == "B":
		char = string
		changeTile32(row, col, 13, 0, 0, 0)
	elif string == "C":
		char = string
		changeTile32(row, col, 14, 0, 0, 0)
	elif string == "D":
		char = string
		changeTile32(row, col, 15, 0, 0, 0)
	elif string == "E":
		char = string
		changeTile32(row, col, 16, 0, 0, 0)
	elif string == "F":
		char = string
		changeTile32(row, col, 17, 0, 0, 0)
	elif string == "G":
		char = string
		changeTile32(row, col, 18, 0, 0, 0)
	elif string == "H":
		char = string
		changeTile32(row, col, 19, 0, 0, 0)	
	elif string == "I":
		char = string
		changeTile32(row, col, 20, 0, 0, 0)
	elif string == "J":
		char = string
		changeTile32(row, col, 21, 0, 0, 0)
	elif string == "K":
		char = string
		changeTile32(row, col, 22, 0, 0, 0)
	elif string == "L":
		char = string
		changeTile32(row, col, 23, 0, 0, 0)
	elif string == "M":
		char = string
		changeTile32(row, col, 24, 0, 0, 0)
	elif string == "N":
		char = string
		changeTile32(row, col, 25, 0, 0, 0)
	elif string == "O":
		char = string
		changeTile32(row, col, 26, 0, 0, 0)
	elif string == "P":
		char = string
		changeTile32(row, col, 27, 0, 0, 0)	
	elif string == "Q":
		char = string
		changeTile32(row, col, 28, 0, 0, 0)
	elif string == "R":
		char = string
		changeTile32(row, col, 29, 0, 0, 0)
	elif string == "S":
		char = string
		changeTile32(row, col, 30, 0, 0, 0)
	elif string == "T":
		char = string
		changeTile32(row, col, 31, 0, 0, 0)
	elif string == "U":
		char = string
		changeTile32(row, col, 32, 0, 0, 0)
	elif string == "V":
		char = string
		changeTile32(row, col, 33, 0, 0, 0)
	elif string == "W":
		char = string
		changeTile32(row, col, 34, 0, 0, 0)
	elif string == "X":
		char = string
		changeTile32(row, col, 35, 0, 0, 0)	
	elif string == "Y":
		char = string
		changeTile32(row, col, 36, 0, 0, 0)
	elif string == "Z":
		char = string
		changeTile32(row, col, 37, 0, 0, 0)
	elif string == "a":
		char = string
		changeTile32(row, col, 38, 0, 0, 0)
	elif string == "b":
		char = string
		changeTile32(row, col, 39, 0, 0, 0)
	elif string == "c":
		char = string
		changeTile32(row, col, 40, 0, 0, 0)
	elif string == "d":
		char = string
		changeTile32(row, col, 41, 0, 0, 0)
	elif string == "e":
		char = string
		changeTile32(row, col, 42, 0, 0, 0)
	elif string == "f":
		char = string
		changeTile32(row, col, 43, 0, 0, 0)		
	elif string == "g":
		char = string
		changeTile32(row, col, 44, 0, 0, 0)
	elif string == "h":
		char = string
		changeTile32(row, col, 45, 0, 0, 0)
	elif string == "i":
		char = string
		changeTile32(row, col, 46, 0, 0, 0)
	elif string == "j":
		char = string
		changeTile32(row, col, 47, 0, 0, 0)
	elif string == "k":
		char = string
		changeTile32(row, col, 48, 0, 0, 0)
	elif string == "l":
		char = string
		changeTile32(row, col, 49, 0, 0, 0)
	elif string == "m":
		char = string
		changeTile32(row, col, 50, 0, 0, 0)
	elif string == "n":
		char = string
		changeTile32(row, col, 51, 0, 0, 0)	
	elif string == "o":
		char = string
		changeTile32(row, col, 52, 0, 0, 0)
	elif string == "p":
		char = string
		changeTile32(row, col, 53, 0, 0, 0)
	elif string == "q":
		char = string
		changeTile32(row, col, 54, 0, 0, 0)
	elif string == "r":
		char = string
		changeTile32(row, col, 55, 0, 0, 0)
	elif string == "s":
		char = string
		changeTile32(row, col, 56, 0, 0, 0)
	elif string == "t":
		char = string
		changeTile32(row, col, 57, 0, 0, 0)
	elif string == "u":
		char = string
		changeTile32(row, col, 58, 0, 0, 0)
	elif string == "v":
		char = string
		changeTile32(row, col, 59, 0, 0, 0)
	elif string == "w":
		char = string
		changeTile32(row, col, 60, 0, 0, 0)
	elif string == "x":
		char = string
		changeTile32(row, col, 61, 0, 0, 0)		
	elif string == "y":
		char = string
		changeTile32(row, col, 62, 0, 0, 0)
	elif string == "z":
		char = string
		changeTile32(row, col, 63, 0, 0, 0)
	elif string == "0":
		char = string
		changeTile32(row, col, 64, 0, 0, 0)
	elif string == "1":
		char = string
		changeTile32(row, col, 65, 0, 0, 0)
	elif string == "2":
		char = string
		changeTile32(row, col, 66, 0, 0, 0)
	elif string == "3":
		char = string
		changeTile32(row, col, 67, 0, 0, 0)
	elif string == "4":
		char = string
		changeTile32(row, col, 68, 0, 0, 0)
	elif string == "5":
		char = string
		changeTile32(row, col, 69, 0, 0, 0)	
	elif string == "6":
		char = string
		changeTile32(row, col, 70, 0, 0, 0)
	elif string == "7":
		char = string
		changeTile32(row, col, 71, 0, 0, 0)
	elif string == "8":
		char = string
		changeTile32(row, col, 72, 0, 0, 0)
	elif string == "9":
		char = string
		changeTile32(row, col, 73, 0, 0, 0)
	elif string == "10":
		char = string
		changeTile32(row, col, 74, 0, 0, 0)
	elif string == ":":
		char = string
		changeTile32(row, col, 116, 0, 0, 0)
	elif string == "?":
		char = string
		changeTile32(row, col, 117, 0, 0, 0)
	elif string == " ":
		char = string
		changeTile32(row, col, 11, 0, 0, 0)
	else:
		changeTile32(row, col, 11, 0, 0, 0)
	return char

#Display a character at a coordinate on the 16 side	
def displayChar16(string, row, col):
	char = ""
	if string == "A":
		char = string
		changeTile16(row, col, 3+12, 0, 0, 0)
	elif string == "B":
		char = string
		changeTile16(row, col, 3+13, 0, 0, 0)
	elif string == "C":
		char = string
		changeTile16(row, col, 3+14, 0, 0, 0)
	elif string == "D":
		char = string
		changeTile16(row, col, 3+15, 0, 0, 0)
	elif string == "E":
		char = string
		changeTile16(row, col, 3+16, 0, 0, 0)
	elif string == "F":
		char = string
		changeTile16(row, col, 3+17, 0, 0, 0)
	elif string == "G":
		char = string
		changeTile16(row, col, 3+18, 0, 0, 0)
	elif string == "H":
		char = string
		changeTile16(row, col, 3+19, 0, 0, 0)	
	elif string == "I":
		char = string
		changeTile16(row, col, 3+20, 0, 0, 0)
	elif string == "J":
		char = string
		changeTile16(row, col, 3+21, 0, 0, 0)
	elif string == "K":
		char = string
		changeTile16(row, col, 3+22, 0, 0, 0)
	elif string == "L":
		char = string
		changeTile16(row, col, 3+23, 0, 0, 0)
	elif string == "M":
		char = string
		changeTile16(row, col, 3+24, 0, 0, 0)
	elif string == "N":
		char = string
		changeTile16(row, col, 3+25, 0, 0, 0)
	elif string == "O":
		char = string
		changeTile16(row, col, 3+26, 0, 0, 0)
	elif string == "P":
		char = string
		changeTile16(row, col, 3+27, 0, 0, 0)	
	elif string == "Q":
		char = string
		changeTile16(row, col, 3+28, 0, 0, 0)
	elif string == "R":
		char = string
		changeTile16(row, col, 3+29, 0, 0, 0)
	elif string == "S":
		char = string
		changeTile16(row, col, 3+30, 0, 0, 0)
	elif string == "T":
		char = string
		changeTile16(row, col, 3+31, 0, 0, 0)
	elif string == "U":
		char = string
		changeTile16(row, col, 3+32, 0, 0, 0)
	elif string == "V":
		char = string
		changeTile16(row, col, 3+33, 0, 0, 0)
	elif string == "W":
		char = string
		changeTile16(row, col, 3+34, 0, 0, 0)
	elif string == "X":
		char = string
		changeTile16(row, col, 3+35, 0, 0, 0)	
	elif string == "Y":
		char = string
		changeTile16(row, col, 3+36, 0, 0, 0)
	elif string == "Z":
		char = string
		changeTile16(row, col, 3+37, 0, 0, 0)
	elif string == "a":
		char = string
		changeTile16(row, col, 3+38, 0, 0, 0)
	elif string == "b":
		char = string
		changeTile16(row, col, 3+39, 0, 0, 0)
	elif string == "c":
		char = string
		changeTile16(row, col, 3+40, 0, 0, 0)
	elif string == "d":
		char = string
		changeTile16(row, col, 3+41, 0, 0, 0)
	elif string == "e":
		char = string
		changeTile16(row, col, 3+42, 0, 0, 0)
	elif string == "f":
		char = string
		changeTile16(row, col, 3+43, 0, 0, 0)		
	elif string == "g":
		char = string
		changeTile16(row, col, 3+44, 0, 0, 0)
	elif string == "h":
		char = string
		changeTile16(row, col, 3+45, 0, 0, 0)
	elif string == "i":
		char = string
		changeTile16(row, col, 3+46, 0, 0, 0)
	elif string == "j":
		char = string
		changeTile16(row, col, 3+47, 0, 0, 0)
	elif string == "k":
		char = string
		changeTile16(row, col, 3+48, 0, 0, 0)
	elif string == "l":
		char = string
		changeTile16(row, col, 3+49, 0, 0, 0)
	elif string == "m":
		char = string
		changeTile16(row, col, 3+50, 0, 0, 0)
	elif string == "n":
		char = string
		changeTile16(row, col, 3+51, 0, 0, 0)	
	elif string == "o":
		char = string
		changeTile16(row, col, 3+52, 0, 0, 0)
	elif string == "p":
		char = string
		changeTile16(row, col, 3+53, 0, 0, 0)
	elif string == "q":
		char = string
		changeTile16(row, col, 3+54, 0, 0, 0)
	elif string == "r":
		char = string
		changeTile16(row, col, 3+55, 0, 0, 0)
	elif string == "s":
		char = string
		changeTile16(row, col, 3+56, 0, 0, 0)
	elif string == "t":
		char = string
		changeTile16(row, col, 3+57, 0, 0, 0)
	elif string == "u":
		char = string
		changeTile16(row, col, 3+58, 0, 0, 0)
	elif string == "v":
		char = string
		changeTile16(row, col, 3+59, 0, 0, 0)
	elif string == "w":
		char = string
		changeTile16(row, col, 3+60, 0, 0, 0)
	elif string == "x":
		char = string
		changeTile16(row, col, 3+61, 0, 0, 0)		
	elif string == "y":
		char = string
		changeTile16(row, col, 3+62, 0, 0, 0)
	elif string == "z":
		char = string
		changeTile16(row, col, 3+63, 0, 0, 0)
	elif string == "0":
		char = string
		changeTile16(row, col, 3+64, 0, 0, 0)
	elif string == "1":
		char = string
		changeTile16(row, col, 3+65, 0, 0, 0)
	elif string == "2":
		char = string
		changeTile16(row, col, 3+66, 0, 0, 0)
	elif string == "3":
		char = string
		changeTile16(row, col, 3+67, 0, 0, 0)
	elif string == "4":
		char = string
		changeTile16(row, col, 3+68, 0, 0, 0)
	elif string == "5":
		char = string
		changeTile16(row, col, 3+69, 0, 0, 0)	
	elif string == "6":
		char = string
		changeTile16(row, col, 3+70, 0, 0, 0)
	elif string == "7":
		char = string
		changeTile16(row, col, 3+71, 0, 0, 0)
	elif string == "8":
		char = string
		changeTile16(row, col, 3+72, 0, 0, 0)
	elif string == "9":
		char = string
		changeTile16(row, col, 3+73, 0, 0, 0)
	elif string == "10":
		char = string
		changeTile16(row, col, 3+74, 0, 0, 0)
	elif string == ":":
		char = string
		changeTile16(row, col, 124, 0, 0, 0)
	elif string == "?":
		char = string
		changeTile16(row, col, 125, 0, 0, 0)
	elif string == " ":
		char = string
		changeTile16(row, col, 14, 0, 0, 0)
	else:
		changeTile16(row, col, 14, 0, 0, 0)
	return char

#Get the players name and display it
def getPlayerName():
	#Set the cursor to the beginning of the ENTERNAME box
	cursorX = 1
	cursorY = 2
	invert32(cursorY, cursorX)
	name = ""
	displayString32("Enter Name:", 1, 1)
	root.update()
	input = ""
	input = getInput()
	while input != "Return":
		print(input)
		if input == "BackSpace" and cursorX > 1:
			if (cursorX < 12):
				invert32(cursorY, cursorX)
			cursorX = cursorX - 1
			changeTile32(cursorY, cursorX, 11, 0, 0, 0)
			invert32(cursorY, cursorX)
			name = name[0:cursorX-1]
		elif cursorX <= 11 and input != "BackSpace" and input != "Left" and input != "Right" and input != "Up" and input != "Down" and input != "Escape":
			name = name + displayChar32(input, cursorY, cursorX)
			cursorX = cursorX + 1
			if (cursorX < 12):
				invert32(cursorY, cursorX)
		input = getInput()
	print "Name:", name
	return name
	
#Every time a key is pressed it gets set to inputKey
def key(event):
	global inputKey
	inputKey = ""
	#print("I have noticed a key event!")
	#shows key or tk code for the key
	#print(event.keysym)
	if event.char == event.keysym:
	# normal number and letter characters
		inputKey = event.char
	if event.keysym == 'Escape' or event.keysym == 'Left' or event.keysym == 'Right' or event.keysym == 'Up' or event.keysym == 'Down' or event.keysym == 'Return' or event.keysym == 'BackSpace' or event.keysym == 'space': 
		inputKey = event.keysym
	#print("inputKey has been changed to:")
	#print(inputKeyGLOBAL[0])
	return

#Get a key from the inputList queue
def getInput():
	global inputKey
	#print("I am attempting to get a key from the user")
	while inputKey == "":
		root.update()
	input = inputKey
	if inputKey == "space":
		input == " "
	inputKey = ""
	#print("I have successfully gotten a keystroke")
	#print(input)
	return input
	
#Load the tiles from the disk
def initializeDisplayData():
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Black 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Red 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Green 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Blue 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/White 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Basic Ocean 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Hit Beacon 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Miss Beacon 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Border 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Explosion 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Splash Ocean 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Space 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/A U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/B U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/C U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/D U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/E U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/F U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/G U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/H U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/I U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/J U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/K U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/L U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/M U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/N U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/O U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/P U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Q U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/R U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/S U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/T U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/U U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/V U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/W U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/X U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Y U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Z U 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/A L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/B L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/C L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/D L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/E L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/F L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/G L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/H L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/I L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/J L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/K L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/L L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/M L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/N L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/O L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/P L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Q L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/R L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/S L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/T L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/U L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/V L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/W L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/X L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Y L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Z L 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/0 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/4 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/5 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/6 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/7 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/8 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/9 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/10 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier 4 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier 5 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship 4 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Destroyer 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Destroyer 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Destroyer 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Submarine 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Submarine 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Submarine 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Patrol Boat 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Patrol Boat 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier Hit 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier Hit 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier Hit 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier Hit 4 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Aircraft Carrier Hit 5 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Hit 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Hit 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Hit 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Hit 4 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Destroyer Hit 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Destroyer Hit 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Destroyer Hit 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Submarine Hit 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Submarine Hit 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Submarine Hit 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Patrol Boat Hit 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Patrol Boat Hit 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 1 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 2 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 3 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 4 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 5 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 6 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Battleship Title 7 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Colon 32.bmp"))
	tiles32.append(Image.open("./Tiles/32x32 Tiles/Question 32.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Black 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Red 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Green 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Blue 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/White 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Basic Ocean 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Hit Beacon 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Miss Beacon 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Border Top Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Border Top Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Border Bottom Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Border Bottom Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Explosion 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Splash Ocean 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Space 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/A U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/B U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/C U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/D U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/E U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/F U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/G U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/H U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/I U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/J U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/K U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/L U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/M U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/N U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/O U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/P U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Q U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/R U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/S U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/T U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/U U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/V U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/W U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/X U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Y U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Z U 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/A L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/B L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/C L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/D L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/E L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/F L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/G L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/H L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/I L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/J L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/K L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/L L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/M L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/N L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/O L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/P L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Q L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/R L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/S L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/T L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/U L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/V L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/W L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/X L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Y L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Z L 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/0 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/4 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/5 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/6 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/7 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/8 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/9 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/10 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier 4 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier 5 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship 4 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Destroyer 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Destroyer 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Destroyer 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Submarine 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Submarine 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Submarine 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Patrol Boat 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Patrol Boat 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier Hit 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier Hit 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier Hit 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier Hit 4 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Aircraft Carrier Hit 5 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Hit 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Hit 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Hit 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Hit 4 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Destroyer Hit 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Destroyer Hit 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Destroyer Hit 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Submarine Hit 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Submarine Hit 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Submarine Hit 3 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Patrol Boat Hit 1 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Patrol Boat Hit 2 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 8 Upper Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 8 Upper Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 8 Lower Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 8 Lower Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 9 Upper Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 9 Upper Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 9 Lower Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 9 Lower Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 10 Upper Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 10 Upper Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 10 Lower Left 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Battleship Title 10 Lower Right 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Colon 16.bmp"))
	tiles16.append(Image.open("./Tiles/16x16 Tiles/Question 16.bmp"))
	return


#Get the players ship positions and record them, and determine which player goes first.
def initializeRound():
	global playerName, opponentName, cursorX, cursorY, patrolboatleft, submarineleft, destroyerleft, battleshipleft, carrierleft, playerScore, opponentScore
	
	#Initialize score and ship health
	
	patrolboatleft = 2
	submarineleft = 3
	destroyerleft = 3
	battleshipleft = 4
	carrierleft = 5
	playerScore = 0
	opponentScore = 0
	
	
	#Place the Carrier
	displayString32("Place 5 sq ", 1, 1)
	displayString32("Carrier    ", 2, 1)
	cursorY = 4
	cursorX = 2
	carrier = 0
	print ("I am now going to try to get a location for the carrier")
	while carrier == 0:
		getLocation32()
		print "I got a location: ", cursorX, ", ", cursorY
		if checkValidShip(cursorX, cursorY, 5, "Left") or checkValidShip(cursorX, cursorY, 5, "Right") or checkValidShip(cursorX, cursorY, 5, "Up") or checkValidShip(cursorX, cursorY, 5, "Down"):
			carrier = 1
		else:
			print "Invalid placement for carrier"
			invert32(cursorY, cursorX)
			
	print "Valid location for carrier"
	carrier = 0
	displayString32("Direction? ", 1, 1)
	displayString32("Length: 5  ", 2, 1)
	while carrier == 0:
		input = getInput()
		if input == "Left" and checkValidShip(cursorX, cursorY, 5, "Left"):
			placeCarrier(cursorX, cursorY, "Left")
			carrier = 1
		if input == "Right" and checkValidShip(cursorX, cursorY, 5, "Right"):
			placeCarrier(cursorX, cursorY, "Right")
			carrier = 1
		if input == "Up" and checkValidShip(cursorX, cursorY, 5, "Up"):
			placeCarrier(cursorX, cursorY, "Up")
			carrier = 1
		if input == "Down" and checkValidShip(cursorX, cursorY, 5, "Down"):
			placeCarrier(cursorX, cursorY, "Down")
			carrier = 1
	print "You placed a carrier!"
	
	#Place the Battleship
	displayString32("Place 4 sq ", 1, 1)
	displayString32("Battleship ", 2, 1)
	cursorY = 4
	cursorX = 2
	battleship = 0
	print ("I am now going to try to get a location for the battleship")
	while battleship == 0:
		getLocation32()
		print "I got a location: ", cursorX, ", ", cursorY
		if checkValidShip(cursorX, cursorY, 4, "Left") or checkValidShip(cursorX, cursorY, 4, "Right") or checkValidShip(cursorX, cursorY, 4, "Up") or checkValidShip(cursorX, cursorY, 4, "Down"):
			battleship = 1
		else:
			print "Invalid placement for battleship"
			invert32(cursorY, cursorX)
			
	print "Valid location for battleship"
	battleship = 0
	displayString32("Direction? ", 1, 1)
	displayString32("Length: 4  ", 2, 1)
	while battleship == 0:
		input = getInput()
		if input == "Left" and checkValidShip(cursorX, cursorY, 4, "Left"):
			placeBattleship(cursorX, cursorY, "Left")
			battleship = 1
		if input == "Right" and checkValidShip(cursorX, cursorY, 4, "Right"):
			placeBattleship(cursorX, cursorY, "Right")
			battleship = 1
		if input == "Up" and checkValidShip(cursorX, cursorY, 4, "Up"):
			placeBattleship(cursorX, cursorY, "Up")
			battleship = 1
		if input == "Down" and checkValidShip(cursorX, cursorY, 4, "Down"):
			placeBattleship(cursorX, cursorY, "Down")
			battleship = 1
	print "You placed a battleship!"
	
	#Place the Destroyer
	displayString32("Place 3 sq ", 1, 1)
	displayString32("Destroyer  ", 2, 1)
	cursorY = 4
	cursorX = 2
	destroyer = 0
	print ("I am now going to try to get a location for the destroyer")
	while destroyer == 0:
		getLocation32()
		print "I got a location: ", cursorX, ", ", cursorY
		if checkValidShip(cursorX, cursorY, 3, "Left") or checkValidShip(cursorX, cursorY, 3, "Right") or checkValidShip(cursorX, cursorY, 3, "Up") or checkValidShip(cursorX, cursorY, 3, "Down"):
			destroyer = 1
		else:
			print "Invalid placement for destroyer"
			invert32(cursorY, cursorX)
			
	print "Valid location for destroyer"
	destroyer = 0
	displayString32("Direction? ", 1, 1)
	displayString32("Length: 3  ", 2, 1)
	while destroyer == 0:
		input = getInput()
		if input == "Left" and checkValidShip(cursorX, cursorY, 3, "Left"):
			placeDestroyer(cursorX, cursorY, "Left")
			destroyer = 1
		if input == "Right" and checkValidShip(cursorX, cursorY, 3, "Right"):
			placeDestroyer(cursorX, cursorY, "Right")
			destroyer = 1
		if input == "Up" and checkValidShip(cursorX, cursorY, 3, "Up"):
			placeDestroyer(cursorX, cursorY, "Up")
			destroyer = 1
		if input == "Down" and checkValidShip(cursorX, cursorY, 3, "Down"):
			placeDestroyer(cursorX, cursorY, "Down")
			destroyer = 1
	print "You placed a destroyer!"
	
	#Place the Submarine
	displayString32("Place 3 sq ", 1, 1)
	displayString32("Submarine  ", 2, 1)
	cursorY = 4
	cursorX = 2
	submarine = 0
	print ("I am now going to try to get a location for the submarine")
	while submarine == 0:
		getLocation32()
		print "I got a location: ", cursorX, ", ", cursorY
		if checkValidShip(cursorX, cursorY, 3, "Left") or checkValidShip(cursorX, cursorY, 3, "Right") or checkValidShip(cursorX, cursorY, 3, "Up") or checkValidShip(cursorX, cursorY, 3, "Down"):
			submarine = 1
		else:
			print "Invalid placement for submarine"
			invert32(cursorY, cursorX)
			
	print "Valid location for submarine"
	submarine = 0
	displayString32("Direction? ", 1, 1)
	displayString32("Length: 3  ", 2, 1)
	while submarine == 0:
		input = getInput()
		if input == "Left" and checkValidShip(cursorX, cursorY, 3, "Left"):
			placeSubmarine(cursorX, cursorY, "Left")
			submarine = 1
		if input == "Right" and checkValidShip(cursorX, cursorY, 3, "Right"):
			placeSubmarine(cursorX, cursorY, "Right")
			submarine = 1
		if input == "Up" and checkValidShip(cursorX, cursorY, 3, "Up"):
			placeSubmarine(cursorX, cursorY, "Up")
			submarine = 1
		if input == "Down" and checkValidShip(cursorX, cursorY, 3, "Down"):
			placeSubmarine(cursorX, cursorY, "Down")
			submarine = 1
	print "You placed a submarine!"
	
	#Place the Patrol Boat
	displayString32("Place 2 sq ", 1, 1)
	displayString32("Patrol Boat", 2, 1)
	cursorY = 4
	cursorX = 2
	patrolboat = 0
	print ("I am now going to try to get a location for the patrol boat")
	while patrolboat == 0:
		getLocation32()
		print "I got a location: ", cursorX, ", ", cursorY
		if checkValidShip(cursorX, cursorY, 2, "Left") or checkValidShip(cursorX, cursorY, 2, "Right") or checkValidShip(cursorX, cursorY, 2, "Up") or checkValidShip(cursorX, cursorY, 2, "Down"):
			patrolboat = 1
		else:
			print "Invalid placement for patrol boat"
			invert32(cursorY, cursorX)
			
	print "Valid location for patrol boat"
	patrolboat = 0
	displayString32("Direction? ", 1, 1)
	displayString32("Length: 2  ", 2, 1)
	while patrolboat == 0:
		input = getInput()
		if input == "Left" and checkValidShip(cursorX, cursorY, 2, "Left"):
			placePatrolBoat(cursorX, cursorY, "Left")
			patrolboat = 1
		if input == "Right" and checkValidShip(cursorX, cursorY, 2, "Right"):
			placePatrolBoat(cursorX, cursorY, "Right")
			patrolboat = 1
		if input == "Up" and checkValidShip(cursorX, cursorY, 2, "Up"):
			placePatrolBoat(cursorX, cursorY, "Up")
			patrolboat = 1
		if input == "Down" and checkValidShip(cursorX, cursorY, 2, "Down"):
			placePatrolBoat(cursorX, cursorY, "Down")
			patrolboat = 1
	print "You placed a patrol boat!"
	
	displayString16(playerName, 19, 2)
	displayString16(opponentName, 22, 2)
	displayString16("00 Hits", 20, 4)
	displayString16("00 Hits", 23, 4)
	
	#Exchange Ethernet Handshake with other computer.  Send playerName and ready signal, and wait for both to come back.
	
	#sendPacket("Player Name " + playerName)
	#sendPacket("Ready")
	#message1 = receivePacket()
	#receivedName = 0
	#while receivedName == 0:
		#if len(message1) >= 12 and message1[0:12] != "Player Name":
			#opponentName = message1[12:]
			#receivedName = 1
		#else:
			#message1 = receivePacket()
	#message2 = receivePacket()
	#receivedReady = 0
	#while receivedReady == 0:
		#if message2 == "Ready":
			#receivedReady = 1
		#else:
			#message2 = receivePacket()
		
	#displayString16(playerName, 19, 2)
	#displayString16(opponentName, 22, 2)
	return
	
def checkValidShip(x, y, length, direction):
	valid = 1
	if direction == "Left":
		if x-length >= 1:
			for i in range (x-length, x):
				if display32[y, i+1, 0] != 5:
					valid = 0
		else:
			valid = 0
				
	elif direction == "Right":
		if x+length <= 12:
			for i in range (x, x+length):
				if display32[y, i, 0] != 5:
					valid = 0
		else:
			valid = 0
	
	elif direction == "Up":
		if y - length >= 3:
			for i in range (y-length, y):
				if display32[i+1, x, 0] != 5:
					valid = 0
		else:
			valid = 0
				
	elif direction == "Down":
		if y + length <= 14:
			for i in range (y, y+length):
				if display32[i, x, 0] != 5:
					valid = 0
		else:
			valid = 0
	
	return valid
	
def placeCarrier(x, y, direction):
	if direction == "Left":
		changeTile32(y, x, 75, 1, 1, 0)
		changeTile32(y, x-1, 76, 1, 1, 0)
		changeTile32(y, x-2, 77, 1, 1, 0)
		changeTile32(y, x-3, 78, 1, 1, 0)
		changeTile32(y, x-4, 79, 1, 1, 0)
				
	elif direction == "Right":
		changeTile32(y, x, 75, 1, 0, 0)
		changeTile32(y, x+1, 76, 1, 0, 0)
		changeTile32(y, x+2, 77, 1, 0, 0)
		changeTile32(y, x+3, 78, 1, 0, 0)
		changeTile32(y, x+4, 79, 1, 0, 0)
	
	elif direction == "Up":
		changeTile32(y, x, 75, 0, 1, 0)
		changeTile32(y-1, x, 76, 0, 1, 0)
		changeTile32(y-2, x, 77, 0, 1, 0)
		changeTile32(y-3, x, 78, 0, 1, 0)
		changeTile32(y-4, x, 79, 0, 1, 0)
				
	elif direction == "Down":
		changeTile32(y, x, 75, 0, 0, 0)
		changeTile32(y+1, x, 76, 0, 0, 0)
		changeTile32(y+2, x, 77, 0, 0, 0)
		changeTile32(y+3, x, 78, 0, 0, 0)
		changeTile32(y+4, x, 79, 0, 0, 0)
	return
	
def placeBattleship(x, y, direction):
	if direction == "Left":
		changeTile32(y, x, 80, 1, 1, 0)
		changeTile32(y, x-1, 81, 1, 1, 0)
		changeTile32(y, x-2, 82, 1, 1, 0)
		changeTile32(y, x-3, 83, 1, 1, 0)

	elif direction == "Right":
		changeTile32(y, x, 80, 1, 0, 0)
		changeTile32(y, x+1, 81, 1, 0, 0)
		changeTile32(y, x+2, 82, 1, 0, 0)
		changeTile32(y, x+3, 83, 1, 0, 0)

	elif direction == "Up":
		changeTile32(y, x, 80, 0, 1, 0)
		changeTile32(y-1, x, 81, 0, 1, 0)
		changeTile32(y-2, x, 82, 0, 1, 0)
		changeTile32(y-3, x, 83, 0, 1, 0)

	elif direction == "Down":
		changeTile32(y, x, 80, 0, 0, 0)
		changeTile32(y+1, x, 81, 0, 0, 0)
		changeTile32(y+2, x, 82, 0, 0, 0)
		changeTile32(y+3, x, 83, 0, 0, 0)
	return
	
def placeDestroyer(x, y, direction):
	if direction == "Left":
		changeTile32(y, x, 84, 1, 1, 0)
		changeTile32(y, x-1, 85, 1, 1, 0)
		changeTile32(y, x-2, 86, 1, 1, 0)

	elif direction == "Right":
		changeTile32(y, x, 84, 1, 0, 0)
		changeTile32(y, x+1, 85, 1, 0, 0)
		changeTile32(y, x+2, 86, 1, 0, 0)

	elif direction == "Up":
		changeTile32(y, x, 84, 0, 1, 0)
		changeTile32(y-1, x, 85, 0, 1, 0)
		changeTile32(y-2, x, 86, 0, 1, 0)

	elif direction == "Down":
		changeTile32(y, x, 84, 0, 0, 0)
		changeTile32(y+1, x, 85, 0, 0, 0)
		changeTile32(y+2, x, 86, 0, 0, 0)
	return
	
def placeSubmarine(x, y, direction):
	if direction == "Left":
		changeTile32(y, x, 87, 1, 1, 0)
		changeTile32(y, x-1, 88, 1, 1, 0)
		changeTile32(y, x-2, 89, 1, 1, 0)

	elif direction == "Right":
		changeTile32(y, x, 87, 1, 0, 0)
		changeTile32(y, x+1, 88, 1, 0, 0)
		changeTile32(y, x+2, 89, 1, 0, 0)

	elif direction == "Up":
		changeTile32(y, x, 87, 0, 1, 0)
		changeTile32(y-1, x, 88, 0, 1, 0)
		changeTile32(y-2, x, 89, 0, 1, 0)

	elif direction == "Down":
		changeTile32(y, x, 87, 0, 0, 0)
		changeTile32(y+1, x, 88, 0, 0, 0)
		changeTile32(y+2, x, 89, 0, 0, 0)
	return
	
def placePatrolBoat(x, y, direction):
	if direction == "Left":
		changeTile32(y, x, 90, 1, 1, 0)
		changeTile32(y, x-1, 91, 1, 1, 0)

	elif direction == "Right":
		changeTile32(y, x, 90, 1, 0, 0)
		changeTile32(y, x+1, 91, 1, 0, 0)

	elif direction == "Up":
		changeTile32(y, x, 90, 0, 1, 0)
		changeTile32(y-1, x, 91, 0, 1, 0)

	elif direction == "Down":
		changeTile32(y, x, 90, 0, 0, 0)
		changeTile32(y+1, x, 91, 0, 0, 0)
	return
	
def getLocation32():
	input = ""
	global cursorY, cursorX
	invert32(cursorY, cursorX)
	while input != "Return":
		if cursorX > 11 or cursorX < 2 or cursorY < 4 or cursorY > 13:
			print "Invalid cursor position: ", cursorX, ", ", cursorY
			print "Resetting cursor"
			cursorX = 2
			cursorY = 4
		if input == "Left" and cursorX > 2:
			invert32(cursorY, cursorX)
			cursorX = cursorX - 1
			invert32(cursorY, cursorX)
		elif input == "Right" and cursorX < 11:
			invert32(cursorY, cursorX)
			cursorX = cursorX + 1
			invert32(cursorY, cursorX)
		elif input == "Up" and cursorY > 4:
			invert32(cursorY, cursorX)
			cursorY = cursorY - 1
			invert32(cursorY, cursorX)		
		elif input == "Down" and cursorY < 13:
			invert32(cursorY, cursorX)
			cursorY = cursorY + 1
			invert32(cursorY, cursorX)
			
		elif input == "A" or input == "a":
			invert32(cursorY, cursorX)
			cursorY = 4
			invert32(cursorY, cursorX)
		elif input == "1":
			invert32(cursorY, cursorX)
			cursorX = 2
			invert32(cursorY, cursorX)

		elif input == "B" or input == "b":
			invert32(cursorY, cursorX)
			cursorY = 5
			invert32(cursorY, cursorX)
		elif input == "2":
			invert32(cursorY, cursorX)
			cursorX = 3
			invert32(cursorY, cursorX)
			
		elif input == "C" or input == "c":
			invert32(cursorY, cursorX)
			cursorY = 6
			invert32(cursorY, cursorX)
		elif input == "3":
			invert32(cursorY, cursorX)
			cursorX = 4
			invert32(cursorY, cursorX)
			
		elif input == "D" or input == "d":
			invert32(cursorY, cursorX)
			cursorY = 7
			invert32(cursorY, cursorX)
		elif input == "4":
			invert32(cursorY, cursorX)
			cursorX = 5
			invert32(cursorY, cursorX)
			
		elif input == "E" or input == "e":
			invert32(cursorY, cursorX)
			cursorY = 8
			invert32(cursorY, cursorX)
		elif input == "5":
			invert32(cursorY, cursorX)
			cursorX = 6
			invert32(cursorY, cursorX)
			
		elif input == "F" or input == "f":
			invert32(cursorY, cursorX)
			cursorY = 9
			invert32(cursorY, cursorX)
		elif input == "6":
			invert32(cursorY, cursorX)
			cursorX = 7
			invert32(cursorY, cursorX)
			
		elif input == "G" or input == "g":
			invert32(cursorY, cursorX)
			cursorY = 10
			invert32(cursorY, cursorX)
		elif input == "7":
			invert32(cursorY, cursorX)
			cursorX = 8
			invert32(cursorY, cursorX)
			
		elif input == "H" or input == "h":
			invert32(cursorY, cursorX)
			cursorY = 11
			invert32(cursorY, cursorX)
		elif input == "8":
			invert32(cursorY, cursorX)
			cursorX = 9
			invert32(cursorY, cursorX)
			
		elif input == "I" or input == "i":
			invert32(cursorY, cursorX)
			cursorY = 12
			invert32(cursorY, cursorX)
		elif input == "9":
			invert32(cursorY, cursorX)
			cursorX = 10
			invert32(cursorY, cursorX)
			
		elif input == "J" or input == "j":
			invert32(cursorY, cursorX)
			cursorY = 13
			invert32(cursorY, cursorX)
		elif input == "0":
			invert32(cursorY, cursorX)
			cursorX = 11
			invert32(cursorY, cursorX)

		input = getInput()	
	return
	
def getLocation16():
	input = ""
	global cursorY, cursorX
	invert16(cursorY, cursorX)
	while input != "Return":
		if cursorX > 12 or cursorX < 3 or cursorY < 7 or cursorY > 16:
			print "Invalid cursor position: ", cursorX, ", ", cursorY
			print "Resetting cursor"
			cursorX = 2
			cursorY = 4
		if input == "Left" and cursorX > 3:
			invert16(cursorY, cursorX)
			cursorX = cursorX - 1
			invert16(cursorY, cursorX)
		elif input == "Right" and cursorX < 12:
			invert16(cursorY, cursorX)
			cursorX = cursorX + 1
			invert16(cursorY, cursorX)
		elif input == "Up" and cursorY > 7:
			invert16(cursorY, cursorX)
			cursorY = cursorY - 1
			invert16(cursorY, cursorX)		
		elif input == "Down" and cursorY < 16:
			invert16(cursorY, cursorX)
			cursorY = cursorY + 1
			invert16(cursorY, cursorX)

		elif input == "A" or input == "a":
			invert16(cursorY, cursorX)
			cursorY = 7
			invert16(cursorY, cursorX)
		elif input == "1":
			invert16(cursorY, cursorX)
			cursorX = 3
			invert16(cursorY, cursorX)

		elif input == "B" or input == "b":
			invert16(cursorY, cursorX)
			cursorY = 8
			invert16(cursorY, cursorX)
		elif input == "2":
			invert16(cursorY, cursorX)
			cursorX = 4
			invert16(cursorY, cursorX)

		elif input == "C" or input == "c":
			invert16(cursorY, cursorX)
			cursorY = 9
			invert16(cursorY, cursorX)
		elif input == "3":
			invert16(cursorY, cursorX)
			cursorX = 5
			invert16(cursorY, cursorX)

		elif input == "D" or input == "d":
			invert16(cursorY, cursorX)
			cursorY = 10
			invert16(cursorY, cursorX)
		elif input == "4":
			invert16(cursorY, cursorX)
			cursorX = 6
			invert16(cursorY, cursorX)

		elif input == "E" or input == "e":
			invert16(cursorY, cursorX)
			cursorY = 11
			invert16(cursorY, cursorX)
		elif input == "5":
			invert16(cursorY, cursorX)
			cursorX = 7
			invert16(cursorY, cursorX)

		elif input == "F" or input == "f":
			invert16(cursorY, cursorX)
			cursorY = 12
			invert16(cursorY, cursorX)
		elif input == "6":
			invert16(cursorY, cursorX)
			cursorX = 8
			invert16(cursorY, cursorX)

		elif input == "G" or input == "g":
			invert16(cursorY, cursorX)
			cursorY = 13
			invert16(cursorY, cursorX)
		elif input == "7":
			invert16(cursorY, cursorX)
			cursorX = 9
			invert16(cursorY, cursorX)

		elif input == "H" or input == "h":
			invert16(cursorY, cursorX)
			cursorY = 14
			invert16(cursorY, cursorX)
		elif input == "8":
			invert16(cursorY, cursorX)
			cursorX = 10
			invert16(cursorY, cursorX)

		elif input == "I" or input == "i":
			invert16(cursorY, cursorX)
			cursorY = 15
			invert16(cursorY, cursorX)
		elif input == "9":
			invert16(cursorY, cursorX)
			cursorX = 11
			invert16(cursorY, cursorX)

		elif input == "J" or input == "j":
			invert16(cursorY, cursorX)
			cursorY = 16
			invert16(cursorY, cursorX)
		elif input == "0":
			invert16(cursorY, cursorX)
			cursorX = 12
			invert16(cursorY, cursorX)

		input = getInput()	
	return

#Conduct the players turn
def playerTurn():
	global cursorX, cursorY, playerScore
	fired = 0
	cursorX = 3
	cursorY = 7
	displayString16("Select shot", 3, 2)
	displayString16("location:  ", 4, 2)
	while fired == 0:
		getLocation16()
		if display16[cursorY, cursorX, 0] == 5:
			fired = 1
	x = cursorX - 2
	if x == 10:
		x = 0
	y = cursorY - 6
	if y == 10:
		y = 0	
	print "Shot: ", x, " ", y
	message = "Shot: " + str(x) + " " + str(y)
	sendPacket(message)
	response = 0
	while response == 0:
		message = receivePacket()
		if len(message) >= 3 and message[0:3] == "Hit":
			playerScore = playerScore + 1
			displayString16("Hit        ", 3, 2)
			changeTile16(cursorY, cursorX, 6, 0, 0, 0)
			response = 1
		elif len(message) >= 4 and message[0:4] == "Miss":
			displayString16("Miss       ", 3, 2)
			changeTile16(cursorY, cursorX, 7, 0, 0, 0)
			response = 1
		elif len(message) >= 4 and message[0:4] == "Sunk":
			ship = message[6:7]
			changeTile16(cursorY, cursorX, 6, 0, 0, 0)
			playerScore = playerScore + 1
			displayString16("Sunk       ", 3, 2)
			if ship == "B":
				displayString16("Battleship ", 4, 2)
			
			elif ship == "A":
				displayString16("Carrier    ", 4, 2)
		
			elif ship == "D":
				displayString16("Destroyer  ", 4, 2)
				
			elif ship == "S":
				displayString16("Submarine  ", 4, 2)
				
			elif ship == "P":
				displayString16("Patrol Boat", 4, 2)
			response = 1
	print "I have sent a shot and received a response!"
	return	

#Conduct the opponents turn
def opponentTurn():
	global opponentScore, carrierleft, battleshipleft, destroyerleft, submarineleft, patrolboatleft
	receivedShot = 0
	x = -1
	y = -1
	while receivedShot == 0:
		message = receivePacket()
		if len(message) >= 9 and message[0:5] == "Shot":
			receivedShot = 1
			x = message[6:7]
			y = message[8:9]
			if x == 0:
				x = 10
			if y == 0:
				y = 10
				
	print "I have received a shot"
	
	if display32[y + 3, x + 1, 0] == 5:
		sendPacket("Miss")
		changeTile32(y + 3, x + 1, 7, 0, 0, 0) #Display Miss
	elif display32[y + 3, x + 1, 0] >= 75 and display32[y + 3, x + 1, 0] <= 91:  #If this is an unexploded ship
		opponentScore = opponentScore + 1
		if display32[y + 3, x + 1, 0] >= 75 and display32[y + 3, x + 1, 0] <= 79: #Carrier
			carrierleft = carrierleft - 1
			if carrierleft == 0:
				sendPacket("Sunk A")
				print "Carrier sunk!"
			else:
				sendPacket("Hit")
		elif display32[y + 3, x + 1, 0] >= 80 and display32[y + 3, x + 1, 0] <= 83: #Battleship
			battleshipleft = battleshipleft - 1
			if battleshipleft == 0:
				sendPacket("Sunk B")
				print "Battleship sunk!"
			else:
				sendPacket("Hit")
		elif display32[y + 3, x + 1, 0] >= 84 and display32[y + 3, x + 1, 0] <= 86: #Destroyer
			destroyerleft = destroyerleft - 1
			if destroyerleft == 0:
				sendPacket("Sunk D")
				print "Destroyer sunk!"
			else:
				sendPacket("Hit")
		elif display32[y + 3, x + 1, 0] >= 87 and display32[y + 3, x + 1, 0] <= 89: #Submarine
			submarineleft = submarineleft - 1
			if submarineleft == 0:
				sendPacket("Sunk S")
				print "Submarine sunk!"
			else:
				sendPacket("Hit")
		elif display32[y + 3, x + 1, 0] >= 90 and display32[y + 3, x + 1, 0] <= 91: #Patrol Boat
			patrolboatleft = patrolboatleft - 1
			if patrolboatleft == 0:
				sendPacket("Sunk P")
				print "Patrol Boat sunk!"
			else:
				sendPacket("Hit")
			
		sendPacket("Hit")
		changeTile32(y + 3, x + 1, display[y+3, x+1, 0] + 17, 0, 0, 0) #Display exploded ship part
	else:
		print "Invalid shot attempted"
		sendPacket("Invalid shot")
	return	

#If the player wins
def playerVictory():
	displayString16("Victory    ", 25, 2)
	return

#If the opponent wins
def opponentVictory():
	displayString32("Defeat     ", 25, 2)
	return

#initializeDisplayData()
#initializeDisplay()
main()
print("I have collapsed to the mainloop.")
root.mainloop()